import { useState, useEffect, useLayoutEffect } from 'react';

function createUseMediaFactory(useEffectHook) {
  return query => {
    const [match, setMatch] = useState(false);
    useEffectHook(() => {
      if (!window || !window.matchMedia) {
        return;
      }

      const matchMedia = window.matchMedia(query);

      const updateMatch = event => setMatch(event.matches);

      setMatch(matchMedia.matches);
      matchMedia.addListener(updateMatch);
      return () => {
        matchMedia.removeListener(updateMatch);
      };
    }, [query]);
    return match;
  };
}

const useMedia = createUseMediaFactory(useEffect);
const useMediaLayout = createUseMediaFactory(useLayoutEffect);

export { useMedia, useMediaLayout };
