import { useState, useRef, useEffect } from 'react';

const DEFAULT_DELAY = 500;
function useDebouncedValue(value, {
  timeoutMs
} = {
  timeoutMs: DEFAULT_DELAY
}) {
  const [state, setState] = useState(value);
  const stateRef = useRef(state);
  useEffect(() => {
    if (stateRef.current === value) {
      return;
    }

    const timeout = setTimeout(() => {
      stateRef.current = value;
      setState(value);
    }, timeoutMs);
    return () => {
      clearTimeout(timeout);
    };
  }, [value, timeoutMs]);
  return state;
}

export { useDebouncedValue };
