'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var isomorphicLayoutEffect = require('./isomorphic-layout-effect.js');

function useMountedRef() {
  const mounted = React.useRef(true);
  isomorphicLayoutEffect.useIsomorphicLayoutEffect(() => {
    mounted.current = true;
    return () => {
      mounted.current = false;
    };
  }, []);
  return mounted;
}

exports.useMountedRef = useMountedRef;
