'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');

const canUseDOM = typeof window !== 'undefined' && typeof window.document !== 'undefined' && typeof window.document.createElement !== 'undefined';
/**
 * A hook that resolves to useEffect on the server and useLayoutEffect on the client
 */

const useIsomorphicLayoutEffect = canUseDOM ? React.useLayoutEffect : React.useEffect;

exports.useIsomorphicLayoutEffect = useIsomorphicLayoutEffect;
