'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var isomorphicLayoutEffect = require('./isomorphic-layout-effect.js');

// Adapted from https://overreacted.io/making-setinterval-declarative-with-react-hooks
// Also available at https://github.com/gaearon/overreacted.io/blob/master/src/pages/making-setinterval-declarative-with-react-hooks/index.md
//
// Copyright (c) 2020 Dan Abramov and the contributors.
//
function useInterval(callback, delay) {
  const savedCallback = React.useRef(callback); // Need to use a layout effect to force the saved callback to be synchronously updated during a commit

  isomorphicLayoutEffect.useIsomorphicLayoutEffect(() => {
    savedCallback.current = callback;
  }, [callback]);
  React.useEffect(() => {
    function tick() {
      savedCallback.current();
    }

    if (delay !== null) {
      const id = setInterval(tick, delay);
      return () => clearInterval(id);
    }

    return undefined;
  }, [delay]);
}

exports.useInterval = useInterval;
