'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');

function useDelayedCallback(callback, delay) {
  const timeoutRef = React.useRef();
  React.useEffect(() => {
    return () => {
      if (timeoutRef.current != null) {
        clearTimeout(timeoutRef.current);
      }
    };
  }, []);

  function callbackWithDelay() {
    const timeoutId = setTimeout(() => {
      callback();
      timeoutRef.current = undefined;
    }, delay);
    timeoutRef.current = timeoutId;
  }

  return callbackWithDelay;
}

exports.useDelayedCallback = useDelayedCallback;
