'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');

const DEFAULT_DELAY = 500;
function useDebouncedValue(value, {
  timeoutMs
} = {
  timeoutMs: DEFAULT_DELAY
}) {
  const [state, setState] = React.useState(value);
  const stateRef = React.useRef(state);
  React.useEffect(() => {
    if (stateRef.current === value) {
      return;
    }

    const timeout = setTimeout(() => {
      stateRef.current = value;
      setState(value);
    }, timeoutMs);
    return () => {
      clearTimeout(timeout);
    };
  }, [value, timeoutMs]);
  return state;
}

exports.useDebouncedValue = useDebouncedValue;
