import { useContext } from 'react';
import { EffectContext } from './context.mjs';

function useServerEffect(perform, kind) {
  const manager = useContext(EffectContext);

  if (manager == null || kind != null && !manager.shouldPerform(kind)) {
    return;
  }

  manager.add(perform(), kind);
}

export { useServerEffect };
