'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var server = require('react-dom/server');
var context = require('./context.js');
var manager = require('./manager.js');
var Effect = require('./Effect.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const DEFAULT_MAX_PASSES = 5;
function extract(app, {
  include,
  maxPasses = DEFAULT_MAX_PASSES,
  decorate = identity,
  renderFunction = server.renderToStaticMarkup,
  betweenEachPass,
  afterEachPass
} = {}) {
  // eslint-disable-next-line react/jsx-no-constructed-context-values
  const manager$1 = new manager.EffectManager({
    include
  });
  const element = /*#__PURE__*/React__default["default"].createElement(context.EffectContext.Provider, {
    value: manager$1
  }, decorate(app));
  return async function perform(index = 0) {
    const start = Date.now();
    const result = renderFunction(element);
    const cancelled = !manager$1.finished && index + 1 >= maxPasses;

    if (manager$1.finished || cancelled) {
      const duration = Date.now() - start;
      await manager$1.afterEachPass({
        index,
        finished: true,
        cancelled,
        renderDuration: duration,
        resolveDuration: 0
      });

      if (afterEachPass) {
        await afterEachPass({
          index,
          finished: true,
          cancelled,
          renderDuration: duration,
          resolveDuration: 0
        });
      }

      return result;
    } else {
      const resolveStart = Date.now();
      const renderDuration = resolveStart - start;
      await manager$1.resolve();
      const resolveDuration = Date.now() - resolveStart;
      let performNextPass = true;
      performNextPass = shouldContinue(await manager$1.afterEachPass({
        index,
        finished: false,
        cancelled: false,
        renderDuration,
        resolveDuration
      })) && performNextPass;

      if (afterEachPass) {
        performNextPass = shouldContinue(await afterEachPass({
          index,
          finished: false,
          cancelled: false,
          renderDuration,
          resolveDuration
        })) && performNextPass;
      }

      if (performNextPass) {
        await manager$1.betweenEachPass({
          index,
          finished: false,
          cancelled: false,
          renderDuration,
          resolveDuration
        });

        if (betweenEachPass) {
          await betweenEachPass({
            index,
            finished: false,
            cancelled: false,
            renderDuration,
            resolveDuration
          });
        }
      }

      manager$1.reset();
      return performNextPass ? perform(index + 1) : result;
    }
  }();
}

function shouldContinue(result) {
  return result !== false;
}

function identity(value) {
  return value;
}

exports.Effect = Effect.Effect;
exports.extract = extract;
