'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var context = require('./context.js');

function useServerEffect(perform, kind) {
  const manager = React.useContext(context.EffectContext);

  if (manager == null || kind != null && !manager.shouldPerform(kind)) {
    return;
  }

  manager.add(perform(), kind);
}

exports.useServerEffect = useServerEffect;
