import type { MetadataProperties, Experimental } from '../types';
export type ColorBackgroundAlias = 'bg' | 'bg-active' | 'bg-app' | 'bg-app-active' | 'bg-app-hover' | 'bg-app-selected' | 'bg-caution' | 'bg-caution-strong' | 'bg-caution-subdued' | 'bg-caution-subdued-active' | 'bg-caution-subdued-hover' | 'bg-critical' | 'bg-critical-strong' | 'bg-critical-strong-active' | 'bg-critical-strong-hover' | 'bg-critical-subdued' | 'bg-critical-subdued-active' | 'bg-critical-subdued-hover' | 'bg-disabled' | 'bg-hover' | 'bg-info' | 'bg-info-strong' | 'bg-info-subdued' | 'bg-info-subdued-active' | 'bg-info-subdued-hover' | 'bg-input' | 'bg-inset' | 'bg-inset-strong' | 'bg-interactive' | 'bg-interactive-active' | 'bg-interactive-disabled' | 'bg-interactive-hover' | 'bg-interactive-selected' | 'bg-interactive-subdued' | 'bg-interactive-subdued-active' | 'bg-interactive-subdued-hover' | 'bg-inverse' | 'bg-inverse-active' | 'bg-inverse-hover' | 'bg-magic' | 'bg-magic-hover' | 'bg-magic-active' | 'bg-magic-strong' | 'bg-magic-subdued' | 'bg-magic-subdued-hover' | 'bg-magic-subdued-active' | 'bg-primary' | 'bg-primary-active' | 'bg-primary-hover' | 'bg-primary-subdued' | 'bg-primary-subdued-active' | 'bg-primary-subdued-hover' | 'bg-primary-subdued-selected' | 'bg-strong' | 'bg-strong-active' | 'bg-strong-hover' | 'bg-subdued' | 'bg-subdued-active' | 'bg-subdued-hover' | 'bg-success' | 'bg-success-strong' | 'bg-success-subdued' | 'bg-success-subdued-active' | 'bg-success-subdued-hover' | 'bg-warning' | ColorBackgroundAliasExperimental;
export type ColorBorderAlias = 'border' | 'border-caution' | 'border-caution-subdued' | 'border-critical' | 'border-critical-active' | 'border-critical-hover' | 'border-critical-subdued' | 'border-disabled' | 'border-hover' | 'border-info' | 'border-info-subdued' | 'border-input' | 'border-input-hover' | 'border-interactive' | 'border-interactive-active' | 'border-interactive-disabled' | 'border-interactive-focus' | 'border-interactive-hover' | 'border-interactive-subdued' | 'border-inverse' | 'border-magic' | 'border-magic-strong' | 'border-primary' | 'border-strong' | 'border-strong-hover' | 'border-subdued' | 'border-success' | 'border-success-subdued' | ColorBorderAliasExperimental;
export type ColorIconAlias = 'icon' | 'icon-active' | 'icon-caution' | 'icon-critical' | 'icon-disabled' | 'icon-hover' | 'icon-info' | 'icon-interactive' | 'icon-interactive-active' | 'icon-interactive-disabled' | 'icon-interactive-hover' | 'icon-interactive-inverse' | 'icon-inverse' | 'icon-magic' | 'icon-on-color' | 'icon-primary' | 'icon-subdued' | 'icon-success' | 'icon-warning' | ColorIconAliasExperimental;
export type ColorTextAlias = 'text' | 'text-caution' | 'text-caution-strong' | 'text-critical' | 'text-critical-active' | 'text-critical-strong' | 'text-disabled' | 'text-info' | 'text-info-strong' | 'text-interactive' | 'text-interactive-active' | 'text-interactive-disabled' | 'text-interactive-hover' | 'text-interactive-inverse' | 'text-inverse' | 'text-inverse-subdued' | 'text-magic' | 'text-magic-strong' | 'text-on-color' | 'text-primary' | 'text-primary-hover' | 'text-subdued' | 'text-success' | 'text-success-strong' | 'text-warning-strong' | ColorTextAliasExperimental;
type ColorBackgroundAliasExperimental = Experimental<'bg-backdrop' | 'bg-input-active' | 'bg-input-hover' | 'bg-primary-disabled' | 'bg-secondary' | 'bg-success-strong-active' | 'bg-success-strong-hover' | 'bg-transparent' | 'bg-transparent-active' | 'bg-transparent-disabled' | 'bg-transparent-hover' | 'bg-transparent-primary' | 'bg-transparent-primary-disabled' | 'bg-transparent-secondary-disabled' | 'bg-transparent-subdued' | 'bg-warning-strong' | 'bg-warning-subdued'>;
type ColorTextAliasExperimental = Experimental<'text-warning' | 'text-critical-hover'>;
type ColorIconAliasExperimental = Experimental<'icon-critical-strong-active' | 'icon-critical-strong-hover' | 'icon-critical-strong' | 'icon-info-strong' | 'icon-success-strong' | 'icon-warning-strong'>;
type ColorBorderAliasExperimental = Experimental<'border-input-active' | 'border-critical-strong'>;
type ColorAvatarAliasExperimental = Experimental<'avatar-background' | 'avatar-color' | 'avatar-style-one-background' | 'avatar-style-one-color' | 'avatar-style-two-background' | 'avatar-style-two-color' | 'avatar-style-three-background' | 'avatar-style-three-color' | 'avatar-style-four-background' | 'avatar-style-four-color' | 'avatar-style-five-background' | 'avatar-style-five-color'>;
export type ColorTokenName = `color-${ColorBackgroundAlias}` | `color-${ColorBorderAlias}` | `color-${ColorIconAlias}` | `color-${ColorTextAlias}` | `color-${ColorAvatarAliasExperimental}`;
export type ColorTokenGroup = {
    [TokenName in ColorTokenName]: string;
};
export declare const color: {
    [TokenName in ColorTokenName]: MetadataProperties;
};
export {};
//# sourceMappingURL=color.d.ts.map