'use strict';

var utilities = require('./utilities.js');
var border = require('./token-groups/border.js');
var breakpoints = require('./token-groups/breakpoints.js');
var color = require('./token-groups/color.js');
var font = require('./token-groups/font.js');
var motion = require('./token-groups/motion.js');
var shadow = require('./token-groups/shadow.js');
var space = require('./token-groups/space.js');
var zIndex = require('./token-groups/zIndex.js');

var metadata = createMetadata({
  breakpoints: utilities.tokensToRems(breakpoints.breakpoints),
  border: utilities.tokensToRems(border.border),
  color: color.color,
  font: utilities.tokensToRems(font.font),
  motion: motion.motion,
  shadow: utilities.tokensToRems(shadow.shadow),
  space: utilities.tokensToRems(space.space),
  zIndex: zIndex.zIndex
});
/**
 * Identity function that simply returns the provided tokens with metadata, but additionally
 * validates the input matches the `Metadata` type exactly and infers all members.
 */
function createMetadata(metadata) {
  return metadata;
}

exports.createMetadata = createMetadata;
exports.metadata = metadata;
