import React from 'react';
import { DiscountMethod, DiscountStatus } from '~/constants';
interface BaseProps {
    /**
     * The method (e.g. code, automatic) of the current discount
     */
    discountMethod: DiscountMethod;
    /**
     * The discount type of the current discount, this should be the `appDiscountType.title` value returned by the API.
     */
    appDiscountType: string;
    /**
     * The discount title for Automatic discounts, or discount code for Code discounts.
     */
    discountDescriptor: string;
    /**
     * (optional) Whether the current discount is being created or edited. See {@link EditingDiscountProps} for behavior when the value is true.
     */
    isEditing?: false;
}
/**
 * When `isEditing` is true, the `discountStatus` must also be provided
 */
interface EditingDiscountProps extends Omit<BaseProps, 'isEditing'> {
    isEditing: true;
    /**
     * The status of the current discount
     */
    discountStatus: DiscountStatus;
}
export declare type HeaderProps = BaseProps | EditingDiscountProps;
export declare enum BadgeStatus {
    Success = "success",
    Attention = "attention"
}
export declare function Header(props: HeaderProps): React.JSX.Element;
export {};
