import React from 'react';
import { DiscountClass, DiscountMethod } from '~/constants';
import type { Field } from '~/types';
export interface MethodCardProps {
    /**
     * Title of the discount type
     */
    title: string;
    /**
     * Used to generate the subtitle of the card
     */
    discountClass: DiscountClass;
    /**
     * The discount method (e.g. code, automatic). Used to control whether a text input or a code generator is shown.
     */
    discountMethod: Field<DiscountMethod>;
    /**
     * (optional) When provided, the discount method picker will be hidden
     */
    discountMethodHidden?: boolean;
    /**
     * Field to be used for the discount title.
     */
    discountTitle: Field<string>;
    /**
     * Field to be used for the discount code.
     */
    discountCode: Field<string>;
    /**
     * (optional) If provided, sets the default length of generated discount codes
     *
     * @default DEFAULT_DISCOUNT_CODE_LENGTH
     */
    defaultDiscountCodeLength?: number;
}
export declare function MethodCard({ title, discountClass, discountMethod, discountMethodHidden, discountTitle, discountCode, defaultDiscountCodeLength, }: MethodCardProps): React.JSX.Element;
