import React from 'react';
import { TextFieldProps } from '@shopify/polaris';
declare type MassagedTextFieldProps = Omit<TextFieldProps, 'onChange' | 'autoComplete'> & {
    /** Called with unformatted value when field loses focus */
    onChange(value: string): void;
    /**
     * (optional) When provided, sets the autocomplete property of the underlying TextField
     * @default 'off'
     */
    autoComplete?: string;
};
interface AdditionalProps {
    /**
     * (optional) This component is _not_ fully controlled and the `onChange` prop is triggered with the real numeric (read: not currency formatted) value when the field loses focus.
     *
     * To avoid the chance of your state storing an invalid number, use this prop _only_ if you need to trigger some action (e.g. clearing error state) when the field is changed.
     */
    onInput?: (value: string) => void;
    /** (optional) Minimum number of fractional digits to display */
    minimumFractionDigits?: number;
    /** (optional) Maximum number of fractional digits to display */
    maximumFractionDigits?: number;
    /** (optional) Forces values to be positive */
    positiveOnly?: boolean;
    /** (optional) Uses the provided placeholder when input is set to empty */
    defaultToPlaceholder?: boolean;
    /** (optional) Ignores all formatting and behaves like a regular TextField when set to true */
    noFormatting?: boolean;
    /** (optional) Function to format the input */
    format?: (value: string) => string;
    /** (optional) Function to unformat the input */
    unformat?: (value: string) => string;
}
export declare type FormattedNumberFieldProps = MassagedTextFieldProps & AdditionalProps;
export declare function FormattedNumberField({ value, format, unformat, noFormatting, autoComplete, placeholder, defaultToPlaceholder, onChange, onInput, onBlur, positiveOnly, minimumFractionDigits, maximumFractionDigits, ...textFieldProps }: FormattedNumberFieldProps): React.JSX.Element;
export {};
