import React from 'react';
import { Eligibility } from '../../constants';
import type { Customer, CustomerSegment, Field } from '../../types';
export interface CustomerEligibilityCardProps {
    /**
     * Controls whether the discount is applied to all customers, specific customers, or specific customer groups
     */
    eligibility: Field<Eligibility>;
    /**
     * Widget that enables users to select customers (see docs for an example)
     */
    customerSelector: React.ReactNode;
    /**
     * List of customers that the discount will be applied to
     */
    selectedCustomers: Field<Customer[]>;
    /**
     * Widget that enables users to select customer segments (see docs for an example)
     */
    customerSegmentSelector: React.ReactNode;
    /**
     * List of customer segments that the discount will be applied to
     */
    selectedCustomerSegments: Field<CustomerSegment[]>;
}
export declare function CustomerEligibilityCard({ eligibility, customerSelector, selectedCustomers, customerSegmentSelector, selectedCustomerSegments, }: CustomerEligibilityCardProps): React.JSX.Element;
export declare const SelectedCustomersList: ({ selectedCustomers, }: {
    selectedCustomers: Field<Customer[]>;
}) => React.JSX.Element;
export declare const SelectedCustomerSegmentsList: ({ selectedCustomerSegments, }: {
    selectedCustomerSegments: Field<CustomerSegment[]>;
}) => React.JSX.Element;
