import React from 'react';
import { DiscountMethod, DiscountStatus } from '~/constants';
import { MoneyInput } from '~/types';
export interface PerformanceProps {
    /**
     * (optional) The status of the discount (e.g. active, expired, scheduled).
     */
    status?: DiscountStatus;
    /**
     * (optional) The number of times the discount has been used
     */
    usageCount?: number;
    /**
     * (optional) Flag that indicates whether a shop has an enabled `ShopFeatures` of `reports` (see https://shopify.dev/api/admin-graphql/2022-04/objects/ShopFeatures#field-shopfeatures-reports)
     */
    hasReports?: boolean;
    /**
     * (optional) When hasReports is true and discountMethod is Code, displays a link to the admin report
     */
    discountMethod?: DiscountMethod;
    /**
     * (optional) The total number of sales that have been made with the discount
     */
    totalSales?: MoneyInput;
}
export declare function Performance({ status, totalSales, hasReports, discountMethod, usageCount, }: PerformanceProps): React.JSX.Element;
