import { getIanaTimeZone, getTimeZoneOffset, applyTimeZoneOffset } from '@shopify/dates';
import { memoize } from 'lodash';

const getDateTimeInShopTimeZone = (date, ianaTimezone) => applyTimeZoneOffset(new Date(date), getIanaTimeZone(), ianaTimezone);
const getDateInShopTimeZone = (date, ianaTimezone) => applyTimeZoneOffset(date, getIanaTimeZone(), ianaTimezone);

/**
 * Removes browser and shop timezone offset from a date.
 */
const getDateInUTC = (date, ianaTimezone) => applyTimeZoneOffset(date, ianaTimezone, getIanaTimeZone());

/**
 * Given the shop timezone, returns a timezone offset in hours between the shop timezone and the browser timezone.
 *
 * @param ianaTimezone - Iana
 */
const getBrowserAndShopTimeZoneOffset = memoize(ianaTimezone => {
  const browserTimeZone = getIanaTimeZone();
  const timeZoneOffsetMinutes = getTimeZoneOffset(new Date(), browserTimeZone, ianaTimezone);
  return timeZoneOffsetMinutes / 60;
});

/**
 * Given a date, returns a copy of the same date at the start of day.
 */
const getNewDateAtStartOfDay = date => {
  const newDate = new Date(date.getTime());
  newDate.setHours(0, 0, 0, 0);
  return newDate;
};

/**
 * Given a date, returns a copy of the same date at the end of day.
 */
const getNewDateAtEndOfDay = date => {
  const newDate = new Date(date.getTime());
  newDate.setHours(23, 59, 59, 999);
  return newDate;
};

export { getBrowserAndShopTimeZoneOffset, getDateInShopTimeZone, getDateInUTC, getDateTimeInShopTimeZone, getNewDateAtEndOfDay, getNewDateAtStartOfDay };
