import React from 'react';
import { LegacyStack, TextField, Text, InlineError, VerticalStack, ChoiceList } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import styles from './RecurringPayment.scss.js';
import { RecurringPaymentType } from '../../../../constants.js';
import { forcePositiveInteger } from '../../../../utilities/numbers.js';

const RECURRING_PAYMENT_FIELD_ID = 'RECURRING_PAYMENT_FIELD_ID';
function RecurringPayment({
  recurringPaymentType,
  recurringPaymentLimit
}) {
  const [i18n] = useI18n();
  const choices = [{
    label: i18n.translate('DiscountAppComponents.RecurringPayment.firstPayment'),
    value: RecurringPaymentType.FirstPayment
  }, {
    label: i18n.translate('DiscountAppComponents.RecurringPayment.multiplePayments'),
    value: RecurringPaymentType.MultiplePayments,
    renderChildren: isSelected => {
      return isSelected && /*#__PURE__*/React.createElement(LegacyStack, {
        vertical: true,
        spacing: "extraTight"
      }, /*#__PURE__*/React.createElement("div", {
        className: styles.RecurringPaymentTextField
      }, /*#__PURE__*/React.createElement(TextField, {
        id: RECURRING_PAYMENT_FIELD_ID,
        label: i18n.translate('DiscountAppComponents.RecurringPayment.multiplePayments'),
        labelHidden: true,
        value: recurringPaymentLimit.value,
        autoComplete: "off",
        onChange: nextValue => {
          recurringPaymentLimit.onChange(forcePositiveInteger(nextValue));
        },
        onBlur: recurringPaymentLimit.onBlur,
        error: Boolean(recurringPaymentLimit.error)
      })), /*#__PURE__*/React.createElement(Text, {
        as: "span",
        color: "subdued"
      }, i18n.translate('DiscountAppComponents.RecurringPayment.includesFirstPayment')), recurringPaymentLimit.error && /*#__PURE__*/React.createElement(InlineError, {
        fieldID: RECURRING_PAYMENT_FIELD_ID,
        message: recurringPaymentLimit.error
      }));
    }
  }, {
    label: i18n.translate('DiscountAppComponents.RecurringPayment.allPayments'),
    value: RecurringPaymentType.AllPayments
  }];
  return /*#__PURE__*/React.createElement(VerticalStack, null, /*#__PURE__*/React.createElement(Text, {
    variant: "headingXs",
    as: "h3"
  }, i18n.translate('DiscountAppComponents.RecurringPayment.title')), /*#__PURE__*/React.createElement(ChoiceList, {
    title: i18n.translate('DiscountAppComponents.RecurringPayment.options'),
    titleHidden: true,
    selected: [recurringPaymentType.value],
    choices: choices,
    onChange: paymentChoice => recurringPaymentType.onChange(paymentChoice[0])
  }));
}

export { RecurringPayment };
