import React from 'react';
import { List } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.UsageLimits'
};
function UsageLimits({
  totalUsageLimit,
  oncePerCustomer
}) {
  const [i18n] = useI18n();
  return /*#__PURE__*/React.createElement(List.Item, null, getUsageSummary(totalUsageLimit, oncePerCustomer, i18n));
}
const getUsageSummary = (totalUsageLimit, oncePerCustomer, i18n) => {
  const hasValidUsageLimit = totalUsageLimit !== null && totalUsageLimit.length > 0;
  if (hasValidUsageLimit) {
    return i18n.translate(oncePerCustomer ? 'totalUsageLimitWithOneUsePerCustomer' : 'totalUsageLimit', I18N_SCOPE, {
      count: Number(totalUsageLimit)
    });
  } else if (oncePerCustomer) {
    return i18n.translate('oneUsePerCustomer', I18N_SCOPE);
  } else {
    return i18n.translate('noUsageLimits', I18N_SCOPE);
  }
};

export { UsageLimits };
