import React from 'react';
import { List } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { Eligibility } from '../../../../constants.js';

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.CustomerEligibility'
};
function CustomerEligibility({
  eligibility,
  selectedCustomerSegments,
  selectedCustomers
}) {
  const [i18n] = useI18n();
  switch (eligibility) {
    case Eligibility.Everyone:
      return /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('allCustomers', I18N_SCOPE));
    case Eligibility.Customers:
      return selectedCustomers !== null && selectedCustomers !== void 0 && selectedCustomers.length ? /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('customers', I18N_SCOPE, {
        customerName: selectedCustomers[0].displayName,
        count: selectedCustomers.length
      })) : null;
    case Eligibility.CustomerSegments:
      return selectedCustomerSegments !== null && selectedCustomerSegments !== void 0 && selectedCustomerSegments.length ? /*#__PURE__*/React.createElement(List.Item, null, i18n.translate('customerSegments', I18N_SCOPE, {
        segmentName: selectedCustomerSegments[0].name,
        count: selectedCustomerSegments.length
      })) : null;
    default:
      return null;
  }
}

export { CustomerEligibility };
