import React from 'react';
import { useI18n } from '@shopify/react-i18n';
import { LegacyCard, LegacyStack, Text, List } from '@shopify/polaris';
import { Header } from './components/Header/Header.js';
import { AppliesToPurchaseType } from './components/AppliesToPurchaseType/AppliesToPurchaseType.js';
import { RecurringPayment } from './components/RecurringPayment/RecurringPayment.js';
import { SelectedCountries } from './components/SelectedCountries/SelectedCountries.js';
import { MaximumShippingPrice } from './components/MaximumShippingPrice/MaximumShippingPrice.js';
import { MinimumRequirements } from './components/MinimumRequirements/MinimumRequirements.js';
import { CustomerEligibility } from './components/CustomerEligibility/CustomerEligibility.js';
import { UsageLimits } from './components/UsageLimits/UsageLimits.js';
import { Combinations } from './components/Combinations/Combinations.js';
import { ActiveDates } from './components/ActiveDates/ActiveDates.js';
import { Performance } from './components/Performance/Performance.js';

/* eslint-disable @shopify/typescript/prefer-pascal-case-enums */
var OptionalSection = /*#__PURE__*/function (OptionalSection) {
  OptionalSection["activeDates"] = "activeDates";
  OptionalSection["additionalDetails"] = "additionalDetails";
  OptionalSection["appliesToPurchaseType"] = "appliesToPurchaseType";
  OptionalSection["combinations"] = "combinations";
  OptionalSection["customerEligibility"] = "customerEligibility";
  OptionalSection["maximumShippingPrice"] = "maximumShippingPrice";
  OptionalSection["minimumRequirements"] = "minimumRequirements";
  OptionalSection["recurringPayment"] = "recurringPayment";
  OptionalSection["selectedCountries"] = "selectedCountries";
  OptionalSection["usageLimits"] = "usageLimits";
  return OptionalSection;
}(OptionalSection || {});
const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard'
};
function SummaryCard(props) {
  var _props$additionalDeta;
  const [i18n] = useI18n();
  const showDetailsSection = Object.values(OptionalSection).some(section => props[section]);
  return /*#__PURE__*/React.createElement(LegacyCard, {
    subdued: true,
    title: i18n.translate('title', I18N_SCOPE)
  }, /*#__PURE__*/React.createElement(LegacyCard.Section, null, /*#__PURE__*/React.createElement(LegacyStack, {
    vertical: true,
    spacing: "loose"
  }, /*#__PURE__*/React.createElement(Header, props.header), showDetailsSection && /*#__PURE__*/React.createElement(LegacyStack, {
    vertical: true,
    spacing: "tight"
  }, /*#__PURE__*/React.createElement(Text, {
    variant: "headingXs",
    as: "h3"
  }, i18n.translate('details', I18N_SCOPE)), /*#__PURE__*/React.createElement(List, {
    type: "bullet"
  }, (_props$additionalDeta = props.additionalDetails) === null || _props$additionalDeta === void 0 ? void 0 : _props$additionalDeta.map(detail => /*#__PURE__*/React.createElement(List.Item, {
    key: detail.replace(/\s/g, '-')
  }, detail)), props.appliesToPurchaseType && /*#__PURE__*/React.createElement(AppliesToPurchaseType, props.appliesToPurchaseType), props.recurringPayment && /*#__PURE__*/React.createElement(RecurringPayment, props.recurringPayment), props.selectedCountries && /*#__PURE__*/React.createElement(SelectedCountries, props.selectedCountries), props.maximumShippingPrice && /*#__PURE__*/React.createElement(MaximumShippingPrice, props.maximumShippingPrice), props.minimumRequirements && /*#__PURE__*/React.createElement(MinimumRequirements, props.minimumRequirements), props.customerEligibility && /*#__PURE__*/React.createElement(CustomerEligibility, props.customerEligibility), props.usageLimits && /*#__PURE__*/React.createElement(UsageLimits, props.usageLimits), props.combinations && /*#__PURE__*/React.createElement(Combinations, props.combinations), props.activeDates && /*#__PURE__*/React.createElement(ActiveDates, props.activeDates))))), /*#__PURE__*/React.createElement(Performance, props.performance));
}

export { SummaryCard };
