import React from 'react';
import { Button } from '@shopify/polaris';
import { CancelSmallMinor } from '@shopify/polaris-icons';
import styles from './Item.scss.js';

function Item({
  children,
  onRemove
}) {
  return /*#__PURE__*/React.createElement("li", {
    className: styles.Item
  }, /*#__PURE__*/React.createElement("div", {
    className: styles.Content
  }, children), onRemove && /*#__PURE__*/React.createElement("div", {
    className: styles.Actions
  }, /*#__PURE__*/React.createElement(Button, {
    icon: CancelSmallMinor,
    plain: true,
    onClick: () => onRemove()
  })));
}

export { Item };
