import React from 'react';
import { LegacyCard, LegacyStack, Text, ChoiceList, TextField } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { DiscountMethod, DEFAULT_DISCOUNT_CODE_LENGTH, DiscountClass } from '../../constants.js';
import { DiscountCodeGenerator } from '../DiscountCodeGenerator/DiscountCodeGenerator.js';

const DISCOUNT_TITLE_MAX_LENGTH = 255;
function MethodCard({
  title,
  discountClass,
  discountMethod,
  discountMethodHidden,
  discountTitle,
  discountCode,
  defaultDiscountCodeLength = DEFAULT_DISCOUNT_CODE_LENGTH
}) {
  const [i18n] = useI18n();
  const handleChangeMethod = methods => {
    discountMethod.onChange(methods[0]);
  };
  return /*#__PURE__*/React.createElement(LegacyCard, null, /*#__PURE__*/React.createElement(LegacyCard.Section, null, /*#__PURE__*/React.createElement(LegacyStack, {
    distribution: "equalSpacing",
    alignment: "center"
  }, /*#__PURE__*/React.createElement(Text, {
    variant: "headingMd",
    as: "h2"
  }, title), /*#__PURE__*/React.createElement(Text, {
    as: "span",
    color: "subdued"
  }, getDiscountClassLabel(discountClass, i18n)))), /*#__PURE__*/React.createElement(LegacyCard.Section, {
    title: !discountMethodHidden && i18n.translate('DiscountAppComponents.MethodCard.methodSubtitle')
  }, /*#__PURE__*/React.createElement(LegacyStack, {
    vertical: true
  }, !discountMethodHidden && /*#__PURE__*/React.createElement(ChoiceList, {
    title: i18n.translate('DiscountAppComponents.MethodCard.choiceList.title'),
    titleHidden: true,
    choices: [{
      value: DiscountMethod.Code,
      label: i18n.translate('DiscountAppComponents.MethodCard.choiceList.code')
    }, {
      value: DiscountMethod.Automatic,
      label: i18n.translate('DiscountAppComponents.MethodCard.choiceList.automatic')
    }],
    selected: [discountMethod.value],
    onChange: handleChangeMethod
  }), discountMethod.value === DiscountMethod.Code ? /*#__PURE__*/React.createElement(DiscountCodeGenerator, {
    defaultLength: defaultDiscountCodeLength,
    discountCode: discountCode
  }) : /*#__PURE__*/React.createElement(TextField, Object.assign({
    autoComplete: "off",
    label: i18n.translate('DiscountAppComponents.MethodCard.discountField.label'),
    helpText: i18n.translate('DiscountAppComponents.MethodCard.discountField.helpText'),
    maxLength: DISCOUNT_TITLE_MAX_LENGTH
  }, discountTitle)))));
}
const getDiscountClassLabel = (discountClass, i18n) => {
  switch (discountClass) {
    case DiscountClass.Order:
      return i18n.translate('DiscountAppComponents.MethodCard.discountClassLabel.order');
    case DiscountClass.Product:
      return i18n.translate('DiscountAppComponents.MethodCard.discountClassLabel.product');
    case DiscountClass.Shipping:
      return i18n.translate('DiscountAppComponents.MethodCard.discountClassLabel.shipping');
    default:
      return '';
  }
};

export { MethodCard };
