import React from 'react';
import { TextField, Button } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { generateRandomDiscountCode } from './utilities.js';
import { DEFAULT_DISCOUNT_CODE_LENGTH } from '../../constants.js';

function DiscountCodeGenerator({
  discountCode,
  defaultLength = DEFAULT_DISCOUNT_CODE_LENGTH
}) {
  const [i18n] = useI18n();
  const handleGenerateDiscount = () => discountCode.onChange(generateRandomDiscountCode(defaultLength));
  return /*#__PURE__*/React.createElement(TextField, Object.assign({
    autoComplete: "off",
    label: i18n.translate('DiscountAppComponents.DiscountCodeGenerator.field.label'),
    helpText: i18n.translate('DiscountAppComponents.DiscountCodeGenerator.field.helpText')
  }, discountCode, {
    connectedRight: /*#__PURE__*/React.createElement(Button, {
      onClick: handleGenerateDiscount
    }, i18n.translate('DiscountAppComponents.DiscountCodeGenerator.buttonText'))
  }));
}

export { DiscountCodeGenerator };
