import React from 'react';
import { LegacyCard, ChoiceList, LegacyStack } from '@shopify/polaris';
import { useI18n } from '@shopify/react-i18n';
import { Action } from '@shopify/app-bridge/actions/Navigation/Redirect';
import { parseGid } from '@shopify/admin-graphql-api-utilities';
import { Eligibility } from '../../constants.js';
import styles from './CustomerEligibilityCard.scss.js';
import { AppBridgeLink } from '../AppBridgeLink/AppBridgeLink.js';
import { SelectedItemsList } from '../SelectedItemsList/SelectedItemsList.js';

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.CustomerEligibilityCard'
};
function CustomerEligibilityCard({
  eligibility,
  customerSelector,
  selectedCustomers,
  customerSegmentSelector,
  selectedCustomerSegments
}) {
  const [i18n] = useI18n();
  return /*#__PURE__*/React.createElement(LegacyCard, {
    title: i18n.translate('title', I18N_SCOPE),
    sectioned: true
  }, /*#__PURE__*/React.createElement(ChoiceList, {
    title: i18n.translate('title', I18N_SCOPE),
    titleHidden: true,
    selected: [eligibility.value],
    choices: [{
      label: i18n.translate('everyone', I18N_SCOPE),
      value: Eligibility.Everyone
    }, {
      label: i18n.translate('customerSegments', I18N_SCOPE),
      value: Eligibility.CustomerSegments
    }, {
      label: i18n.translate('customers', I18N_SCOPE),
      value: Eligibility.Customers
    }],
    onChange: selectedEligibility => {
      eligibility.onChange(selectedEligibility[0]);
    }
  }), eligibility.value === Eligibility.CustomerSegments && /*#__PURE__*/React.createElement(LegacyStack, {
    vertical: true,
    spacing: "extraTight"
  }, customerSegmentSelector, /*#__PURE__*/React.createElement(SelectedCustomerSegmentsList, {
    selectedCustomerSegments: selectedCustomerSegments
  })), eligibility.value === Eligibility.Customers && /*#__PURE__*/React.createElement(LegacyStack, {
    vertical: true,
    spacing: "extraTight"
  }, customerSelector, /*#__PURE__*/React.createElement(SelectedCustomersList, {
    selectedCustomers: selectedCustomers
  })));
}
const SelectedCustomersList = ({
  selectedCustomers
}) => {
  const renderCustomerItem = ({
    email,
    displayName
  }) => /*#__PURE__*/React.createElement("div", {
    className: styles.CustomerItem
  }, /*#__PURE__*/React.createElement("span", null, displayName), email && /*#__PURE__*/React.createElement("span", {
    className: styles.Email,
    title: email
  }, email));
  const handleRemoveCustomer = customerId => {
    selectedCustomers.onChange(selectedCustomers.value.filter(({
      id
    }) => id !== customerId));
  };
  return /*#__PURE__*/React.createElement(SelectedItemsList, {
    items: selectedCustomers.value,
    renderItem: renderCustomerItem,
    onRemoveItem: handleRemoveCustomer
  });
};
const SelectedCustomerSegmentsList = ({
  selectedCustomerSegments
}) => {
  const renderCustomerSegmentItem = ({
    name,
    id
  }) => /*#__PURE__*/React.createElement(AppBridgeLink, {
    external: true,
    action: Action.ADMIN_PATH,
    url: `/customers?segment_id=${parseGid(id)}`
  }, name);
  const handleRemoveCustomerSegment = customerSegmentId => {
    selectedCustomerSegments.onChange(selectedCustomerSegments.value.filter(({
      id
    }) => id !== customerSegmentId));
  };
  return /*#__PURE__*/React.createElement(SelectedItemsList, {
    items: selectedCustomerSegments.value,
    renderItem: renderCustomerSegmentItem,
    onRemoveItem: handleRemoveCustomerSegment
  });
};

export { CustomerEligibilityCard, SelectedCustomerSegmentsList, SelectedCustomersList };
