import React from 'react';
import { useI18n } from '@shopify/react-i18n';
import { LegacyStack } from '@shopify/polaris';
import { FormattedNumberField } from '../FormattedNumberField/FormattedNumberField.js';

const DEFAULT_MAX_LENGTH = 24;
function CurrencyField({
  currencyCode,
  hideCurrencyCode,
  hidePrefix,
  hideSuffix,
  appendSuffixToCurrency,
  suffix,
  prefix,
  ...rest
}) {
  var _rest$maxLength;
  const [i18n] = useI18n();
  return /*#__PURE__*/React.createElement(FormattedNumberField, Object.assign({
    maxLength: (_rest$maxLength = rest.maxLength) !== null && _rest$maxLength !== void 0 ? _rest$maxLength : DEFAULT_MAX_LENGTH
  }, rest, {
    prefix: Boolean(!hidePrefix && !hideCurrencyCode) && renderPrefix(prefix, i18n, currencyCode),
    suffix: Boolean(!hideSuffix && !hideCurrencyCode) && renderSuffix(suffix, i18n, currencyCode, appendSuffixToCurrency),
    format: value => i18n.formatCurrency(Number(value), {
      currency: currencyCode,
      form: 'none'
    }),
    unformat: value => i18n.unformatCurrency(value, currencyCode)
  }));
}
function currencyMetadata(i18n, currencyCode) {
  return i18n.getCurrencySymbolLocalized(i18n.locale, currencyCode);
}
function renderPrefix(prefix, i18n, currencyCode) {
  const {
    prefixed,
    symbol
  } = currencyMetadata(i18n, currencyCode);
  return prefixed ? prefix || symbol : prefix;
}
function renderSuffix(suffix, i18n, currencyCode, appendSuffixToCurrency) {
  const {
    prefixed,
    symbol
  } = currencyMetadata(i18n, currencyCode);
  if (appendSuffixToCurrency && !prefixed && suffix) {
    return /*#__PURE__*/React.createElement(LegacyStack, {
      alignment: "center",
      spacing: "extraTight"
    }, /*#__PURE__*/React.createElement("div", null, symbol), /*#__PURE__*/React.createElement("div", null, suffix));
  }
  return prefixed ? suffix : suffix || symbol;
}

// eslint-disable-next-line import/no-default-export
var CurrencyField$1 = /*#__PURE__*/React.memo(CurrencyField);

export { CurrencyField$1 as default };
