import React, { useMemo } from 'react';
import { I18nManager, I18nContext } from '@shopify/react-i18n';
import './AppProvider.scss.js';
import { DiscountsI18nProvider } from './components/DiscountsI18nProvider/DiscountsI18nProvider.js';

const FALLBACK_TRANSLATIONS_LOCALE = 'en';
function AppProvider(props) {
  if (!props.locale) {
    throw new Error('DiscountsAppProvider: locale is required');
  } else if (!props.ianaTimezone) {
    throw new Error('DiscountsAppProvider: ianaTimezone is required');
  }
  const i18nManager = useMemo(() => new I18nManager({
    locale: props.locale,
    timezone: props.ianaTimezone,
    fallbackLocale: FALLBACK_TRANSLATIONS_LOCALE
  }), [props.locale, props.ianaTimezone]);
  return /*#__PURE__*/React.createElement(I18nContext.Provider, {
    value: i18nManager
  }, /*#__PURE__*/React.createElement(DiscountsI18nProvider, null, props.children));
}

export { AppProvider };
