'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var actions = require('@shopify/app-bridge/actions');

/**
 * Redirects to the Admin Discounts page if isAdmin is true, otherwise redirects to the app root or a specified fallbackPath within the app.
 */
function onBreadcrumbAction(redirect, isAdmin, fallbackPath) {
  if (isAdmin) {
    handleRedirect({
      redirect,
      url: '/discounts',
      action: actions.Redirect.Action.ADMIN_PATH
    });
  } else {
    handleRedirect({
      redirect,
      url: fallbackPath || '/',
      action: actions.Redirect.Action.APP
    });
  }
}

/**
 * Convenience wrapper for AppBridge [Redirect](https://shopify.dev/apps/tools/app-bridge/actions/navigation/redirect#redirect-to-a-specific-resource-in-shopify-admin) actions
 */
function handleRedirect({
  redirect,
  ...props
}) {
  switch (props.action) {
    case actions.Redirect.Action.ADMIN_PATH:
      redirect.dispatch(actions.Redirect.Action.ADMIN_PATH, {
        path: props.url,
        newContext: Boolean(props.newContext)
      });
      break;
    case actions.Redirect.Action.APP:
      redirect.dispatch(actions.Redirect.Action.APP, props.url);
      break;
    case actions.Redirect.Action.REMOTE:
      redirect.dispatch(actions.Redirect.Action.REMOTE, {
        url: props.url,
        newContext: Boolean(props.newContext)
      });
      break;
    case actions.Redirect.Action.ADMIN_SECTION:
      redirect.dispatch(actions.Redirect.Action.ADMIN_SECTION, props.payload);
      break;
    default:
      throw new Error('Unsupported redirect action. Please refer to https://shopify.dev/apps/tools/app-bridge/actions/navigation/redirect for usage.');
  }
}

exports.handleRedirect = handleRedirect;
exports.onBreadcrumbAction = onBreadcrumbAction;
