'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var dates = require('@shopify/dates');
var lodash = require('lodash');

const getDateTimeInShopTimeZone = (date, ianaTimezone) => dates.applyTimeZoneOffset(new Date(date), dates.getIanaTimeZone(), ianaTimezone);
const getDateInShopTimeZone = (date, ianaTimezone) => dates.applyTimeZoneOffset(date, dates.getIanaTimeZone(), ianaTimezone);

/**
 * Removes browser and shop timezone offset from a date.
 */
const getDateInUTC = (date, ianaTimezone) => dates.applyTimeZoneOffset(date, ianaTimezone, dates.getIanaTimeZone());

/**
 * Given the shop timezone, returns a timezone offset in hours between the shop timezone and the browser timezone.
 *
 * @param ianaTimezone - Iana
 */
const getBrowserAndShopTimeZoneOffset = lodash.memoize(ianaTimezone => {
  const browserTimeZone = dates.getIanaTimeZone();
  const timeZoneOffsetMinutes = dates.getTimeZoneOffset(new Date(), browserTimeZone, ianaTimezone);
  return timeZoneOffsetMinutes / 60;
});

/**
 * Given a date, returns a copy of the same date at the start of day.
 */
const getNewDateAtStartOfDay = date => {
  const newDate = new Date(date.getTime());
  newDate.setHours(0, 0, 0, 0);
  return newDate;
};

/**
 * Given a date, returns a copy of the same date at the end of day.
 */
const getNewDateAtEndOfDay = date => {
  const newDate = new Date(date.getTime());
  newDate.setHours(23, 59, 59, 999);
  return newDate;
};

exports.getBrowserAndShopTimeZoneOffset = getBrowserAndShopTimeZoneOffset;
exports.getDateInShopTimeZone = getDateInShopTimeZone;
exports.getDateInUTC = getDateInUTC;
exports.getDateTimeInShopTimeZone = getDateTimeInShopTimeZone;
exports.getNewDateAtEndOfDay = getNewDateAtEndOfDay;
exports.getNewDateAtStartOfDay = getNewDateAtStartOfDay;
