'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var RecurringPayment$1 = require('./RecurringPayment.scss.js');
var constants = require('../../../../constants.js');
var numbers = require('../../../../utilities/numbers.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const RECURRING_PAYMENT_FIELD_ID = 'RECURRING_PAYMENT_FIELD_ID';
function RecurringPayment({
  recurringPaymentType,
  recurringPaymentLimit
}) {
  const [i18n] = reactI18n.useI18n();
  const choices = [{
    label: i18n.translate('DiscountAppComponents.RecurringPayment.firstPayment'),
    value: constants.RecurringPaymentType.FirstPayment
  }, {
    label: i18n.translate('DiscountAppComponents.RecurringPayment.multiplePayments'),
    value: constants.RecurringPaymentType.MultiplePayments,
    renderChildren: isSelected => {
      return isSelected && /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
        vertical: true,
        spacing: "extraTight"
      }, /*#__PURE__*/React__default["default"].createElement("div", {
        className: RecurringPayment$1["default"].RecurringPaymentTextField
      }, /*#__PURE__*/React__default["default"].createElement(polaris.TextField, {
        id: RECURRING_PAYMENT_FIELD_ID,
        label: i18n.translate('DiscountAppComponents.RecurringPayment.multiplePayments'),
        labelHidden: true,
        value: recurringPaymentLimit.value,
        autoComplete: "off",
        onChange: nextValue => {
          recurringPaymentLimit.onChange(numbers.forcePositiveInteger(nextValue));
        },
        onBlur: recurringPaymentLimit.onBlur,
        error: Boolean(recurringPaymentLimit.error)
      })), /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
        as: "span",
        color: "subdued"
      }, i18n.translate('DiscountAppComponents.RecurringPayment.includesFirstPayment')), recurringPaymentLimit.error && /*#__PURE__*/React__default["default"].createElement(polaris.InlineError, {
        fieldID: RECURRING_PAYMENT_FIELD_ID,
        message: recurringPaymentLimit.error
      }));
    }
  }, {
    label: i18n.translate('DiscountAppComponents.RecurringPayment.allPayments'),
    value: constants.RecurringPaymentType.AllPayments
  }];
  return /*#__PURE__*/React__default["default"].createElement(polaris.VerticalStack, null, /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    variant: "headingXs",
    as: "h3"
  }, i18n.translate('DiscountAppComponents.RecurringPayment.title')), /*#__PURE__*/React__default["default"].createElement(polaris.ChoiceList, {
    title: i18n.translate('DiscountAppComponents.RecurringPayment.options'),
    titleHidden: true,
    selected: [recurringPaymentType.value],
    choices: choices,
    onChange: paymentChoice => recurringPaymentType.onChange(paymentChoice[0])
  }));
}

exports.RecurringPayment = RecurringPayment;
