'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var UsageLimitsCard$1 = require('./UsageLimitsCard.scss.js');
var numbers = require('../../utilities/numbers.js');
var RecurringPayment = require('./components/RecurringPayment/RecurringPayment.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

let UsageLimitType = /*#__PURE__*/function (UsageLimitType) {
  UsageLimitType["TotalUsageLimit"] = "TOTAL_USAGE_LIMIT";
  UsageLimitType["OncePerCustomerLimit"] = "ONCE_PER_CUSTOMER_LIMIT";
  return UsageLimitType;
}({});
const DISCOUNT_TOTAL_USAGE_LIMIT_FIELD = 'totalUsageLimit';
function UsageLimitsCard(props) {
  const {
    totalUsageLimit,
    oncePerCustomer,
    isRecurring
  } = props;
  const [showUsageLimit, setShowUsageLimit] = React.useState(totalUsageLimit.value !== null);
  const [i18n] = reactI18n.useI18n();
  React.useEffect(() => setShowUsageLimit(totalUsageLimit.value !== null), [totalUsageLimit.value]);
  const handleUsageLimitsChoicesChange = selectedUsageLimitTypes => {
    const newOncePerCustomer = selectedUsageLimitTypes.includes(UsageLimitType.OncePerCustomerLimit);

    // When the checkbox is toggled, either set the totalUsageLimit value to null (null === checkbox off) or an empty string (non-null === checkbox on)
    if (!selectedUsageLimitTypes.includes(UsageLimitType.TotalUsageLimit)) {
      totalUsageLimit.onChange(null);
    } else if (totalUsageLimit.value === null) {
      totalUsageLimit.onChange('');
    }
    newOncePerCustomer !== oncePerCustomer.value && oncePerCustomer.onChange(newOncePerCustomer);
  };
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard, {
    title: i18n.translate('DiscountAppComponents.UsageLimitsCard.title')
  }, /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard.Section, null, /*#__PURE__*/React__default["default"].createElement(polaris.ChoiceList, {
    title: i18n.translate('DiscountAppComponents.UsageLimitsCard.options'),
    titleHidden: true,
    allowMultiple: true,
    selected: [...(showUsageLimit ? [UsageLimitType.TotalUsageLimit] : []), ...(oncePerCustomer.value ? [UsageLimitType.OncePerCustomerLimit] : [])],
    choices: [{
      label: i18n.translate('DiscountAppComponents.UsageLimitsCard.totalUsageLimitLabel'),
      value: UsageLimitType.TotalUsageLimit,
      renderChildren: isSelected => /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
        vertical: true,
        spacing: "extraTight"
      }, isSelected && /*#__PURE__*/React__default["default"].createElement("div", {
        className: UsageLimitsCard$1["default"].TotalUsageLimitTextField
      }, /*#__PURE__*/React__default["default"].createElement(polaris.TextField, {
        id: DISCOUNT_TOTAL_USAGE_LIMIT_FIELD,
        label: i18n.translate('DiscountAppComponents.UsageLimitsCard.totalUsageLimitLabel'),
        autoComplete: "off",
        labelHidden: true,
        value: totalUsageLimit.value || '',
        onChange: nextValue => {
          totalUsageLimit.onChange(numbers.forcePositiveInteger(nextValue));
        },
        onBlur: totalUsageLimit.onBlur,
        error: Boolean(totalUsageLimit.error)
      })), isRecurring && /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
        as: "span",
        color: "subdued"
      }, i18n.translate('DiscountAppComponents.UsageLimitsCard.totalUsageLimitHelpTextSubscription')), isSelected && totalUsageLimit.error && /*#__PURE__*/React__default["default"].createElement(polaris.InlineError, {
        fieldID: DISCOUNT_TOTAL_USAGE_LIMIT_FIELD,
        message: totalUsageLimit.error
      }))
    }, {
      label: i18n.translate('DiscountAppComponents.UsageLimitsCard.oncePerCustomerLimitLabel'),
      value: UsageLimitType.OncePerCustomerLimit
    }],
    onChange: handleUsageLimitsChoicesChange
  })), isShowRecurringPaymentSection(props) && /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard.Section, null, /*#__PURE__*/React__default["default"].createElement(RecurringPayment.RecurringPayment, {
    recurringPaymentType: props.recurringPaymentType,
    recurringPaymentLimit: props.recurringPaymentLimit
  })));
}
function isShowRecurringPaymentSection(props) {
  return Boolean(props.isRecurring);
}

exports.DISCOUNT_TOTAL_USAGE_LIMIT_FIELD = DISCOUNT_TOTAL_USAGE_LIMIT_FIELD;
exports.UsageLimitType = UsageLimitType;
exports.UsageLimitsCard = UsageLimitsCard;
