'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.RecurringPayment'
};
function RecurringPayment({
  isRecurring,
  recurringPaymentType,
  recurringPaymentLimit
}) {
  const [i18n] = reactI18n.useI18n();
  if (!isRecurring) {
    return null;
  }
  switch (recurringPaymentType) {
    case constants.RecurringPaymentType.MultiplePayments:
      return recurringPaymentLimit !== null && recurringPaymentLimit !== void 0 && recurringPaymentLimit.length ? /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('subscriptionRecurringPayments', I18N_SCOPE, {
        count: Number(recurringPaymentLimit)
      })) : null;
    case constants.RecurringPaymentType.AllPayments:
      return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('subscriptionRecurringPayments.none', I18N_SCOPE));
    case constants.RecurringPaymentType.FirstPayment:
      return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('subscriptionRecurringPayments', I18N_SCOPE, {
        count: 1
      }));
    default:
      return null;
  }
}

exports.RecurringPayment = RecurringPayment;
