'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactI18n = require('@shopify/react-i18n');
var polaris = require('@shopify/polaris');
var actions = require('@shopify/app-bridge/actions');
var constants = require('../../../../constants.js');
var AppBridgeLink = require('../../../AppBridgeLink/AppBridgeLink.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const CODE_DISCOUNT_ADMIN_REPORT_URL = `/reports/sales_by_discount`;
const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.Performance'
};
function Performance({
  status,
  totalSales,
  hasReports,
  discountMethod,
  usageCount
}) {
  const [i18n] = reactI18n.useI18n();
  const isActiveOrExpired = status === constants.DiscountStatus.Active || status === constants.DiscountStatus.Expired;
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard.Section, {
    title: i18n.translate('title', I18N_SCOPE)
  }, /*#__PURE__*/React__default["default"].createElement(polaris.VerticalStack, null, status === constants.DiscountStatus.Scheduled && /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    as: "span",
    color: "subdued"
  }, i18n.translate('notActive', I18N_SCOPE)), isActiveOrExpired && /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement(polaris.List, {
    type: "bullet"
  }, /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('usageCount', I18N_SCOPE, {
    usageCount
  })), totalSales && /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('totalSales', I18N_SCOPE, {
    totalSales: i18n.formatCurrency(Number(totalSales.amount), {
      currency: totalSales.currencyCode
    })
  }))), hasReports && discountMethod === constants.DiscountMethod.Code && /*#__PURE__*/React__default["default"].createElement("p", null, /*#__PURE__*/React__default["default"].createElement(AppBridgeLink.AppBridgeLink, {
    action: actions.Redirect.Action.ADMIN_PATH,
    url: CODE_DISCOUNT_ADMIN_REPORT_URL
  }, i18n.translate('performanceLink', I18N_SCOPE))))));
}

exports.Performance = Performance;
