'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.MinimumRequirements'
};
function MinimumRequirements({
  requirementType,
  quantity,
  subtotal,
  currencyCode
}) {
  const [i18n] = reactI18n.useI18n();
  switch (requirementType) {
    case constants.RequirementType.None:
      return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('noMinimumPurchaseRequirement', I18N_SCOPE));
    case constants.RequirementType.Subtotal:
      // eslint-disable-next-line no-case-declarations
      const validSubtotal = getValidSubtotal(i18n, currencyCode, subtotal);
      return validSubtotal ? /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('minimumPurchaseSubtotal', I18N_SCOPE, {
        subtotal: validSubtotal
      })) : null;
    case constants.RequirementType.Quantity:
      return isValidQuantity(quantity) ? /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('minimumPurchaseQuantity', I18N_SCOPE, {
        count: Number(quantity)
      })) : null;
    default:
      return null;
  }
}
function getValidSubtotal(i18n, currencyCode, subtotal) {
  if (subtotal === undefined || currencyCode === undefined) {
    return null;
  }
  const subtotalNumber = Number(subtotal);
  const validatedSubtotal = isNaN(subtotalNumber) ? '' : i18n.formatCurrency(Math.abs(subtotalNumber), {
    currency: currencyCode
  });
  if (subtotal.length > 0 && subtotalNumber > 0 && validatedSubtotal.length > 0) {
    return validatedSubtotal;
  }
  return null;
}
function isValidQuantity(quantity) {
  if (quantity === undefined) {
    return false;
  }
  const quantityNumber = Number(quantity);
  const validatedQuantity = isNaN(quantityNumber) ? '' : Math.abs(quantityNumber).toString();
  return quantity.length > 0 && quantityNumber > 0 && validatedQuantity.length > 0;
}

exports.MinimumRequirements = MinimumRequirements;
