'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactI18n = require('@shopify/react-i18n');
var polaris = require('@shopify/polaris');
var constants = require('../../../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

/**
 * When `isEditing` is true, the `discountStatus` must also be provided
 */

let BadgeStatus = /*#__PURE__*/function (BadgeStatus) {
  BadgeStatus["Success"] = "success";
  BadgeStatus["Attention"] = "attention";
  return BadgeStatus;
}({});
const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.Header'
};
function Header(props) {
  const {
    discountMethod,
    discountDescriptor
  } = props;
  const [i18n] = reactI18n.useI18n();
  const trimmedDescriptor = discountDescriptor.trim();
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    vertical: true,
    spacing: "loose"
  }, trimmedDescriptor ? /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    distribution: "equalSpacing",
    alignment: "center",
    wrap: true
  }, /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    variant: "headingMd",
    as: "h3"
  }, trimmedDescriptor), isEditing(props) && renderBadgeForStatus(props.discountStatus, i18n)) : /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    as: "span",
    fontWeight: "semibold",
    color: "subdued"
  }, i18n.translate(`emptyState.${discountMethod}`, I18N_SCOPE)), /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    vertical: true,
    spacing: "tight"
  }, /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    variant: "headingXs",
    as: "h3"
  }, i18n.translate('typeAndMethod', I18N_SCOPE)), /*#__PURE__*/React__default["default"].createElement(polaris.List, {
    type: "bullet"
  }, /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, props.appDiscountType), /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate(`discountMethod.${discountMethod}`, I18N_SCOPE)))));
}
function renderBadgeForStatus(status, i18n) {
  switch (status) {
    case constants.DiscountStatus.Active:
      return /*#__PURE__*/React__default["default"].createElement(polaris.Badge, {
        status: BadgeStatus.Success
      }, i18n.translate('badge.active', I18N_SCOPE));
    case constants.DiscountStatus.Expired:
      return /*#__PURE__*/React__default["default"].createElement(polaris.Badge, null, i18n.translate('badge.expired', I18N_SCOPE));
    case constants.DiscountStatus.Scheduled:
      return /*#__PURE__*/React__default["default"].createElement(polaris.Badge, {
        status: BadgeStatus.Attention
      }, i18n.translate('badge.scheduled', I18N_SCOPE));
    default:
      return null;
  }
}
function isEditing(props) {
  return Boolean(props.isEditing);
}

exports.BadgeStatus = BadgeStatus;
exports.Header = Header;
