'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.CustomerEligibility'
};
function CustomerEligibility({
  eligibility,
  selectedCustomerSegments,
  selectedCustomers
}) {
  const [i18n] = reactI18n.useI18n();
  switch (eligibility) {
    case constants.Eligibility.Everyone:
      return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('allCustomers', I18N_SCOPE));
    case constants.Eligibility.Customers:
      return selectedCustomers !== null && selectedCustomers !== void 0 && selectedCustomers.length ? /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('customers', I18N_SCOPE, {
        customerName: selectedCustomers[0].displayName,
        count: selectedCustomers.length
      })) : null;
    case constants.Eligibility.CustomerSegments:
      return selectedCustomerSegments !== null && selectedCustomerSegments !== void 0 && selectedCustomerSegments.length ? /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, i18n.translate('customerSegments', I18N_SCOPE, {
        segmentName: selectedCustomerSegments[0].name,
        count: selectedCustomerSegments.length
      })) : null;
    default:
      return null;
  }
}

exports.CustomerEligibility = CustomerEligibility;
