'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.Combinations'
};
function Combinations({
  combinesWith
}) {
  const [i18n] = reactI18n.useI18n();
  const combinations = [...(combinesWith.productDiscounts ? [constants.DiscountClass.Product] : []), ...(combinesWith.orderDiscounts ? [constants.DiscountClass.Order] : []), ...(combinesWith.shippingDiscounts ? [constants.DiscountClass.Shipping] : [])];
  return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, getContent(combinations, i18n));
}
function getContent(combinations, i18n) {
  switch (combinations.length) {
    case 0:
      return i18n.translate('cannotCombine', I18N_SCOPE);
    case 1:
      return i18n.translate(`combinesWithOne.${combinations[0].toLowerCase()}`, I18N_SCOPE);
    case 2:
      return i18n.translate(`combinesWithTwo.${combinations[0].toLowerCase()}And${capitalizeFirstLetter(combinations[1].toLowerCase())}`, I18N_SCOPE);
    default:
      return '';
  }
}
function capitalizeFirstLetter(text) {
  return text.charAt(0).toUpperCase() + text.slice(1);
}

exports.Combinations = Combinations;
