'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.SummaryCard.AppliesToPurchaseType'
};
function AppliesToPurchaseType({
  purchaseType
}) {
  const [i18n] = reactI18n.useI18n();
  return /*#__PURE__*/React__default["default"].createElement(polaris.List.Item, null, getPurchaseTypeSummary(purchaseType, i18n));
}
const getPurchaseTypeSummary = (purchaseType, i18n) => {
  switch (purchaseType) {
    case constants.PurchaseType.OneTimePurchase:
      return i18n.translate('appliesToPurchaseTypeOneTime', I18N_SCOPE);
    case constants.PurchaseType.Subscription:
      return i18n.translate('appliesToPurchaseTypeSubscription', I18N_SCOPE);
    case constants.PurchaseType.Both:
      return i18n.translate('appliesToPurchaseTypeBoth', I18N_SCOPE);
  }
};

exports.AppliesToPurchaseType = AppliesToPurchaseType;
