'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var constants = require('../../constants.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function PurchaseTypeCard({
  purchaseType
}) {
  const [i18n] = reactI18n.useI18n();
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard, {
    sectioned: true,
    title: i18n.translate('DiscountAppComponents.PurchaseTypeList.title')
  }, /*#__PURE__*/React__default["default"].createElement(polaris.ChoiceList, {
    title: i18n.translate('DiscountAppComponents.PurchaseTypeList.choiceList.title'),
    titleHidden: true,
    selected: [purchaseType.value],
    choices: [{
      label: i18n.translate('DiscountAppComponents.PurchaseTypeList.choiceList.oneTimePurchase'),
      value: constants.PurchaseType.OneTimePurchase
    }, {
      label: i18n.translate('DiscountAppComponents.PurchaseTypeList.choiceList.subscription'),
      value: constants.PurchaseType.Subscription
    }, {
      label: i18n.translate('DiscountAppComponents.PurchaseTypeList.choiceList.both'),
      value: constants.PurchaseType.Both
    }],
    onChange: purchaseTypeList => {
      purchaseType.onChange(purchaseTypeList[0]);
    }
  }));
}

exports.PurchaseTypeCard = PurchaseTypeCard;
