'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var Redirect = require('@shopify/app-bridge/actions/Navigation/Redirect');
var adminGraphqlApiUtilities = require('@shopify/admin-graphql-api-utilities');
var constants = require('../../constants.js');
var CustomerEligibilityCard$1 = require('./CustomerEligibilityCard.scss.js');
var AppBridgeLink = require('../AppBridgeLink/AppBridgeLink.js');
var SelectedItemsList = require('../SelectedItemsList/SelectedItemsList.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const I18N_SCOPE = {
  scope: 'DiscountAppComponents.CustomerEligibilityCard'
};
function CustomerEligibilityCard({
  eligibility,
  customerSelector,
  selectedCustomers,
  customerSegmentSelector,
  selectedCustomerSegments
}) {
  const [i18n] = reactI18n.useI18n();
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard, {
    title: i18n.translate('title', I18N_SCOPE),
    sectioned: true
  }, /*#__PURE__*/React__default["default"].createElement(polaris.ChoiceList, {
    title: i18n.translate('title', I18N_SCOPE),
    titleHidden: true,
    selected: [eligibility.value],
    choices: [{
      label: i18n.translate('everyone', I18N_SCOPE),
      value: constants.Eligibility.Everyone
    }, {
      label: i18n.translate('customerSegments', I18N_SCOPE),
      value: constants.Eligibility.CustomerSegments
    }, {
      label: i18n.translate('customers', I18N_SCOPE),
      value: constants.Eligibility.Customers
    }],
    onChange: selectedEligibility => {
      eligibility.onChange(selectedEligibility[0]);
    }
  }), eligibility.value === constants.Eligibility.CustomerSegments && /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    vertical: true,
    spacing: "extraTight"
  }, customerSegmentSelector, /*#__PURE__*/React__default["default"].createElement(SelectedCustomerSegmentsList, {
    selectedCustomerSegments: selectedCustomerSegments
  })), eligibility.value === constants.Eligibility.Customers && /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    vertical: true,
    spacing: "extraTight"
  }, customerSelector, /*#__PURE__*/React__default["default"].createElement(SelectedCustomersList, {
    selectedCustomers: selectedCustomers
  })));
}
const SelectedCustomersList = ({
  selectedCustomers
}) => {
  const renderCustomerItem = ({
    email,
    displayName
  }) => /*#__PURE__*/React__default["default"].createElement("div", {
    className: CustomerEligibilityCard$1["default"].CustomerItem
  }, /*#__PURE__*/React__default["default"].createElement("span", null, displayName), email && /*#__PURE__*/React__default["default"].createElement("span", {
    className: CustomerEligibilityCard$1["default"].Email,
    title: email
  }, email));
  const handleRemoveCustomer = customerId => {
    selectedCustomers.onChange(selectedCustomers.value.filter(({
      id
    }) => id !== customerId));
  };
  return /*#__PURE__*/React__default["default"].createElement(SelectedItemsList.SelectedItemsList, {
    items: selectedCustomers.value,
    renderItem: renderCustomerItem,
    onRemoveItem: handleRemoveCustomer
  });
};
const SelectedCustomerSegmentsList = ({
  selectedCustomerSegments
}) => {
  const renderCustomerSegmentItem = ({
    name,
    id
  }) => /*#__PURE__*/React__default["default"].createElement(AppBridgeLink.AppBridgeLink, {
    external: true,
    action: Redirect.Action.ADMIN_PATH,
    url: `/customers?segment_id=${adminGraphqlApiUtilities.parseGid(id)}`
  }, name);
  const handleRemoveCustomerSegment = customerSegmentId => {
    selectedCustomerSegments.onChange(selectedCustomerSegments.value.filter(({
      id
    }) => id !== customerSegmentId));
  };
  return /*#__PURE__*/React__default["default"].createElement(SelectedItemsList.SelectedItemsList, {
    items: selectedCustomerSegments.value,
    renderItem: renderCustomerSegmentItem,
    onRemoveItem: handleRemoveCustomerSegment
  });
};

exports.CustomerEligibilityCard = CustomerEligibilityCard;
exports.SelectedCustomerSegmentsList = SelectedCustomerSegmentsList;
exports.SelectedCustomersList = SelectedCustomersList;
