'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var CountriesAndRatesCard$1 = require('./CountriesAndRatesCard.scss.js');
var utilities = require('./utilities.js');
var constants = require('../../constants.js');
var SelectedItemsList = require('../SelectedItemsList/SelectedItemsList.js');
var CurrencyField = require('../CurrencyField/CurrencyField.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const EXCLUDE_SHIPPING_RATES_FIELD_ID = 'excludeShippingRatesOverTextField';
function CountriesAndRatesCard({
  countrySelectionType,
  selectedCountries,
  maximumShippingPrice,
  excludeShippingRates,
  countrySelector,
  currencyCode
}) {
  const [i18n] = reactI18n.useI18n();
  const localizeCountry = utilities.useLocalizeCountry();
  return /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard, {
    title: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.title')
  }, /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard.Section, null, /*#__PURE__*/React__default["default"].createElement(polaris.ChoiceList, {
    title: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.choiceList.title'),
    titleHidden: true,
    choices: [{
      value: constants.CountrySelectionType.AllCountries,
      label: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.choiceList.all')
    }, {
      value: constants.CountrySelectionType.SelectedCountries,
      label: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.choiceList.selected')
    }],
    selected: [countrySelectionType.value],
    onChange: values => countrySelectionType.onChange(values[0])
  }), countrySelectionType.value === constants.CountrySelectionType.SelectedCountries && /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement("div", {
    className: CountriesAndRatesCard$1["default"].countrySelectorActivator
  }, countrySelector), /*#__PURE__*/React__default["default"].createElement(SelectedItemsList.SelectedItemsList, {
    items: selectedCountries.value.map(localizeCountry),
    renderItem: item => /*#__PURE__*/React__default["default"].createElement("div", null, item.name),
    onRemoveItem: itemId => selectedCountries.onChange(selectedCountries.value.filter(countryCode => countryCode !== itemId))
  }))), /*#__PURE__*/React__default["default"].createElement(polaris.LegacyCard.Section, {
    title: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.excludeShippingRatesSection.title')
  }, /*#__PURE__*/React__default["default"].createElement(polaris.Checkbox, {
    label: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.excludeShippingRatesSection.checkboxLabel'),
    checked: excludeShippingRates.value,
    onChange: value => excludeShippingRates.onChange(value)
  }), excludeShippingRates.value && /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement("div", {
    className: CountriesAndRatesCard$1["default"].ShippingRatesTextField
  }, /*#__PURE__*/React__default["default"].createElement(CurrencyField["default"], {
    id: EXCLUDE_SHIPPING_RATES_FIELD_ID,
    currencyCode: currencyCode,
    error: Boolean(maximumShippingPrice.error),
    labelHidden: true,
    label: i18n.translate('DiscountAppComponents.CountriesAndRatesCard.excludeShippingRatesSection.checkboxLabel'),
    onChange: maximumShippingPrice.onChange,
    value: String(maximumShippingPrice.value),
    positiveOnly: true
  })), (maximumShippingPrice === null || maximumShippingPrice === void 0 ? void 0 : maximumShippingPrice.error) && /*#__PURE__*/React__default["default"].createElement(polaris.InlineError, {
    fieldID: EXCLUDE_SHIPPING_RATES_FIELD_ID,
    message: maximumShippingPrice.error
  }))));
}

exports.CountriesAndRatesCard = CountriesAndRatesCard;
