'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var polaris = require('@shopify/polaris');
var reactI18n = require('@shopify/react-i18n');
var appBridgeReact = require('@shopify/app-bridge-react');
var actions = require('@shopify/app-bridge/actions');
var Modal = require('@shopify/app-bridge/actions/Modal');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const DISCOUNT_COMBINATION_MODAL_APP_BRIDGE_URL = 'shopify://app-bridge/modal/discounts-combinations';
function HelpText({
  currentDiscountClass,
  targetDiscountClass,
  currentDiscountId,
  count,
  currentDiscountName
}) {
  const buttonWrapperRef = React.useRef(null);
  const [i18n] = reactI18n.useI18n();
  const app = appBridgeReact.useAppBridge();
  const myModal = actions.Modal.create(app, {
    url: DISCOUNT_COMBINATION_MODAL_APP_BRIDGE_URL
  });
  const targetDiscountClassLabel = targetDiscountClass.toLocaleLowerCase();
  const scope = `DiscountAppComponents.CombinationCard.HelpText`;
  const handleModalOpen = () => {
    myModal.dispatch(Modal.Action.DATA, {
      discountOptions: {
        currentDiscountName,
        currentDiscountClass,
        currentDiscountId,
        targetDiscountClass
      }
    });
    myModal.dispatch(actions.Modal.Action.OPEN);
    const closeUnsubscribe = myModal.subscribe(actions.Modal.Action.CLOSE, () => {
      var _buttonWrapperRef$cur, _buttonWrapperRef$cur2;
      (_buttonWrapperRef$cur = buttonWrapperRef.current) === null || _buttonWrapperRef$cur === void 0 ? void 0 : (_buttonWrapperRef$cur2 = _buttonWrapperRef$cur.getElementsByTagName('button')[0]) === null || _buttonWrapperRef$cur2 === void 0 ? void 0 : _buttonWrapperRef$cur2.focus();
      closeUnsubscribe();
    });
  };
  return count > 0 ? /*#__PURE__*/React__default["default"].createElement(polaris.LegacyStack, {
    spacing: "none",
    vertical: true
  }, /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    as: "span",
    color: "subdued"
  }, i18n.translate('combinations.info', {
    scope
  }, {
    count,
    discountCountLink: /*#__PURE__*/React__default["default"].createElement("span", {
      ref: buttonWrapperRef
    }, /*#__PURE__*/React__default["default"].createElement(polaris.Button, {
      onClick: handleModalOpen,
      plain: true
    }, i18n.translate(`combinations.counts.${targetDiscountClassLabel}`, {
      scope
    }, {
      count
    })))
  })), /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    as: "span",
    color: "subdued"
  }, i18n.translate('combinations.multipleEligibleDiscounts', {
    scope
  }))) : /*#__PURE__*/React__default["default"].createElement(React__default["default"].Fragment, null, /*#__PURE__*/React__default["default"].createElement(polaris.Text, {
    as: "span",
    color: "subdued"
  }, i18n.translate('title', {
    scope: `${scope}.emptyState.${targetDiscountClass.toLowerCase()}`
  }), ' ', i18n.translate(`warning.with${currentDiscountClass.toLowerCase()}`, {
    scope: `${scope}.emptyState.${targetDiscountClass.toLowerCase()}`
  }), ' ', /*#__PURE__*/React__default["default"].createElement(polaris.Link, {
    url: `https://help.shopify.com/${i18n.locale}/manual/discounts/combining-discounts`,
    external: true
  }, i18n.translate(`${scope}.emptyState.link`))));
}

exports.HelpText = HelpText;
