'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactI18n = require('@shopify/react-i18n');
var en = require('../../../../_virtual/en.json.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n["default"] = e;
  return Object.freeze(n);
}

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

function DiscountsI18nProvider({
  children
}) {
  const [, ShareTranslations] = reactI18n.useI18n({
    id: 'DiscountAppComponents',
    fallback: en["default"],
    async translations(locale) {
      return (function (t) { return Promise.resolve().then(function () { return /*#__PURE__*/_interopNamespace(require(t)); }); })( /* webpackChunkName: "DiscountAppComponents-i18n", webpackMode: "lazy-once" */`../../../../../../locales/${locale}.json`).then(dictionary => {
        if (!dictionary) {
          return undefined;
        }
        return dictionary.default;
      });
    }
  });
  return /*#__PURE__*/React__default["default"].createElement(ShareTranslations, null, children);
}

exports.DiscountsI18nProvider = DiscountsI18nProvider;
