'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var React = require('react');
var reactI18n = require('@shopify/react-i18n');
require('./AppProvider.scss.js');
var DiscountsI18nProvider = require('./components/DiscountsI18nProvider/DiscountsI18nProvider.js');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

const FALLBACK_TRANSLATIONS_LOCALE = 'en';
function AppProvider(props) {
  if (!props.locale) {
    throw new Error('DiscountsAppProvider: locale is required');
  } else if (!props.ianaTimezone) {
    throw new Error('DiscountsAppProvider: ianaTimezone is required');
  }
  const i18nManager = React.useMemo(() => new reactI18n.I18nManager({
    locale: props.locale,
    timezone: props.ianaTimezone,
    fallbackLocale: FALLBACK_TRANSLATIONS_LOCALE
  }), [props.locale, props.ianaTimezone]);
  return /*#__PURE__*/React__default["default"].createElement(reactI18n.I18nContext.Provider, {
    value: i18nManager
  }, /*#__PURE__*/React__default["default"].createElement(DiscountsI18nProvider.DiscountsI18nProvider, null, props.children));
}

exports.AppProvider = AppProvider;
