import { isFutureDate } from './is-future-date.mjs';
import { TimeUnit } from './constants/index.mjs';

function isLessThanOneDayAgo(date, now = new Date()) {
  return !isFutureDate(date, now) && now.getTime() - date.getTime() < TimeUnit.Day;
}

export { isLessThanOneDayAgo };
