/// <reference types="node" resolution-mode="require"/>
/// <reference types="node" resolution-mode="require"/>
import { AbortSignal } from './abort.js';
import { ReadStream } from 'tty';
import type { Writable, Readable } from 'stream';
export interface ExecOptions {
    cwd?: string;
    env?: {
        [key: string]: string | undefined;
    };
    stdin?: Readable | 'inherit';
    stdout?: Writable | 'inherit';
    stderr?: Writable | 'inherit';
    stdio?: 'inherit';
    input?: string;
    signal?: AbortSignal;
    externalErrorHandler?: (error: unknown) => Promise<void>;
}
/**
 * Opens a URL in the user's default browser.
 *
 * @param url - URL to open.
 */
export declare function openURL(url: string): Promise<void>;
/**
 * Runs a command asynchronously, aggregates the stdout data, and returns it.
 *
 * @param command - Command to be executed.
 * @param args - Arguments to pass to the command.
 * @param options - Optional settings for how to run the command.
 * @returns A promise that resolves with the aggregatted stdout of the command.
 */
export declare function captureOutput(command: string, args: string[], options?: ExecOptions): Promise<string>;
/**
 * Runs a command asynchronously.
 *
 * @param command - Command to be executed.
 * @param args - Arguments to pass to the command.
 * @param options - Optional settings for how to run the command.
 */
export declare function exec(command: string, args: string[], options?: ExecOptions): Promise<void>;
/**
 * Waits for a given number of seconds.
 *
 * @param seconds - Number of seconds to wait.
 */
export declare function sleep(seconds: number): Promise<void>;
/**
 * In case an standard input stream is passed check if it supports raw mode. Otherwise default standard input stream
 * will be used.
 *
 * @param stdin - The standard input stream to check.
 * @returns True in the selected input stream support raw mode.
 */
export declare function terminalSupportsRawMode(stdin?: ReadStream): boolean;
