import { AppInterface } from '../models/app/app.js';
import { Config } from '@oclif/core';
interface ReleaseOptions {
    /** The app to be built and uploaded */
    app: AppInterface;
    /** API key of the app in Partners admin */
    apiKey?: string;
    /** If true, ignore any cached appId or extensionId */
    reset: boolean;
    /** If true, proceed with deploy without asking for confirmation */
    force: boolean;
    /** App version tag */
    version: string;
    /** Config from the Oclif command */
    commandConfig: Config;
}
export declare function release(options: ReleaseOptions): Promise<void>;
export {};
