import { LocalStorage } from '@shopify/cli-kit/node/local-storage';
export interface CachedAppInfo {
    directory: string;
    configFile?: string;
    appId?: string;
    title?: string;
    orgId?: string;
    storeFqdn?: string;
    updateURLs?: boolean;
    previousAppId?: string;
}
export interface AppLocalStorageSchema {
    [key: string]: CachedAppInfo;
}
export declare function getCachedAppInfo(directory: string, config?: LocalStorage<AppLocalStorageSchema>): CachedAppInfo | undefined;
export declare function clearCachedAppInfo(directory: string, config?: LocalStorage<AppLocalStorageSchema>): void;
export declare function setCachedAppInfo(options: CachedAppInfo, config?: LocalStorage<AppLocalStorageSchema>): void;
export declare function clearCurrentConfigFile(directory: string, config?: LocalStorage<AppLocalStorageSchema>): void;
export declare function setCachedCommandInfo(data: {
    [key: string]: unknown;
}): void;
export declare function getCachedCommandInfo(): {
    [key: string]: unknown;
} | undefined;
export declare function clearCachedCommandInfo(): void;
