import { loadApp } from '../../models/app/loader.js';
import { loadLocalExtensionsSpecifications } from '../../models/extensions/load-specifications.js';
import { resolvePath, cwd } from '@shopify/cli-kit/node/path';
import { AbortError } from '@shopify/cli-kit/node/error';
import { Flags } from '@oclif/core';
export const functionFlags = {
    path: Flags.string({
        hidden: false,
        description: 'The path to your function directory.',
        parse: async (input) => resolvePath(input),
        default: async () => cwd(),
        env: 'SHOPIFY_FLAG_PATH',
    }),
};
export async function inFunctionContext({ commandConfig, path, configName, callback, }) {
    const specifications = await loadLocalExtensionsSpecifications(commandConfig);
    const app = await loadApp({ specifications, directory: path, configName });
    const allFunctions = app.allExtensions.filter((ext) => ext.isFunctionExtension);
    const ourFunction = allFunctions.find((fun) => fun.directory === path);
    if (ourFunction) {
        return callback(app, ourFunction);
    }
    else {
        throw new AbortError('Run this command from a function directory or use `--path` to specify a function directory.');
    }
}
//# sourceMappingURL=common.js.map